// =============================================================================
// -----------------------------------------------------------------------------
// Program
// -----------------------------------------------------------------------------

#include <stdio.h>
#include "_bitmap.h"

const char PalFile [] = { "Palette.bmp" };
const char HeadFile [] = { "Head.bmp" };
const char TextFile [] = { "Text SHC.bmp" };

#define XY(X,Y) ((X)+((Y)*Image.SizeX))

#define COMPCOL(A,B)\
	A.Red   == B.Red   && A.Green == B.Green && A.Blue  == B.Blue

#define NEGACOL(A,B) \
	A.Red   != B.Red   ||\
	A.Green != B.Green ||\
	A.Blue  != B.Blue

// -----------------------------------------------------------------------------
// Adding the slight pale blues around the edges
// -----------------------------------------------------------------------------

void AddPale (IMG Palette, IMG Image)

{
	for (int Y = 1; Y < (Image.SizeY - 1); Y++)
	{
		for (int X = 1; X < (Image.SizeX - 1); X++)
		{
			int Count = 0;
			if (COMPCOL (Image.Data [XY(X, Y)], Palette.Data [0]))
			{
				if (COMPCOL (Image.Data [XY(X+1, Y  )], Palette.Data [5])) { Count += 2; }
				if (COMPCOL (Image.Data [XY(X+1, Y+1)], Palette.Data [5])) { Count++; }
				if (COMPCOL (Image.Data [XY(X  , Y+1)], Palette.Data [5])) { Count += 2; }
				if (COMPCOL (Image.Data [XY(X-1, Y+1)], Palette.Data [5])) { Count++; }
				if (COMPCOL (Image.Data [XY(X-1, Y  )], Palette.Data [5])) { Count += 2; }
				if (COMPCOL (Image.Data [XY(X-1, Y-1)], Palette.Data [5])) { Count++; }
				if (COMPCOL (Image.Data [XY(X  , Y-1)], Palette.Data [5])) { Count += 2; }
				if (COMPCOL (Image.Data [XY(X+1, Y-1)], Palette.Data [5])) { Count++; }
			}
			if (Count >= 5)
			{
				Image.Data [XY(X, Y)] = Palette.Data [8];
			}
		}
	}
	for (int Y = 1; Y < (Image.SizeY - 1); Y++)
	{
		for (int X = 1; X < (Image.SizeX - 1); X++)
		{
			int Count = 0;
			if (COMPCOL (Image.Data [XY(X, Y)], Palette.Data [0]))
			{
				if (COMPCOL (Image.Data [XY(X+1, Y  )], Palette.Data [5])) { Count += 2; }
				if (COMPCOL (Image.Data [XY(X  , Y+1)], Palette.Data [5])) { Count += 2; }
				if (COMPCOL (Image.Data [XY(X-1, Y  )], Palette.Data [5])) { Count += 2; }
				if (COMPCOL (Image.Data [XY(X  , Y-1)], Palette.Data [5])) { Count += 2; }
			}
			if (Count >= 2)
			{
				Image.Data [XY(X, Y)] = Palette.Data [9];
			}
		}
	}
	for (int Y = 1; Y < (Image.SizeY - 1); Y++)
	{
		for (int X = 1; X < (Image.SizeX - 1); X++)
		{
			int Count = 0;
			int CC =	Image.Data [XY(X, Y)].Red +\
					Image.Data [XY(X, Y)].Green +\
					Image.Data [XY(X, Y)].Blue;
			int PC =	Palette.Data [9].Red +\
					Palette.Data [9].Green +\
					Palette.Data [9].Blue;
			if (CC < PC)
			{
				if (COMPCOL (Image.Data [XY(X+1, Y  )], Palette.Data [4])) { Count += 2; }
				if (COMPCOL (Image.Data [XY(X+1, Y+1)], Palette.Data [4])) { Count++; }
				if (COMPCOL (Image.Data [XY(X  , Y+1)], Palette.Data [4])) { Count += 2; }
				if (COMPCOL (Image.Data [XY(X-1, Y+1)], Palette.Data [4])) { Count++; }
				if (COMPCOL (Image.Data [XY(X-1, Y  )], Palette.Data [4])) { Count += 2; }
				if (COMPCOL (Image.Data [XY(X-1, Y-1)], Palette.Data [4])) { Count++; }
				if (COMPCOL (Image.Data [XY(X  , Y-1)], Palette.Data [4])) { Count += 2; }
				if (COMPCOL (Image.Data [XY(X+1, Y-1)], Palette.Data [4])) { Count++; }
			}
			if (Count >= 5)
			{
				Image.Data [XY(X, Y)] = Palette.Data [6];
			}
		}
	}
	for (int Y = 1; Y < (Image.SizeY - 1); Y++)
	{
		for (int X = 1; X < (Image.SizeX - 1); X++)
		{
			int Count = 0;
			int CC =	Image.Data [XY(X, Y)].Red +\
					Image.Data [XY(X, Y)].Green +\
					Image.Data [XY(X, Y)].Blue;
			int PC =	Palette.Data [8].Red +\
					Palette.Data [8].Green +\
					Palette.Data [8].Blue;
			if (CC < PC)
			{
				if (COMPCOL (Image.Data [XY(X+1, Y  )], Palette.Data [4])) { Count += 2; }
				if (COMPCOL (Image.Data [XY(X  , Y+1)], Palette.Data [4])) { Count += 2; }
				if (COMPCOL (Image.Data [XY(X-1, Y  )], Palette.Data [4])) { Count += 2; }
				if (COMPCOL (Image.Data [XY(X  , Y-1)], Palette.Data [4])) { Count += 2; }
			}
			if (Count >= 2)
			{
				Image.Data [XY(X, Y)] = Palette.Data [7];
			}
		}
	}
}

// -----------------------------------------------------------------------------
// Adding the glow
// -----------------------------------------------------------------------------

void AddGlow (IMG Palette, IMG &Image)

{
	char GlowList [] = {

				17, 17, 1,
				0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0,
				0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0,
				0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0,
				0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0,
				0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0,
				0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0,
				0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0,
				0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0,
				1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
				0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0,
				0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0,
				0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0,
				0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0,
				0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0,
				0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0,
				0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0,
				0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0,

				13, 13, 1,
				0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0,
				0, 0, 0, 0, 1, 1, 1, 1, 1, 0, 0, 0, 0,
				0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0,
				0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0,
				0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0,
				0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0,
				1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
				0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0,
				0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0,
				0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0,
				0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0,
				0, 0, 0, 0, 1, 1, 1, 1, 1, 0, 0, 0, 0,
				0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0,

			/*	9, 9, 0,
				0, 0, 0, 1, 1, 1, 0, 0, 0,
				0, 1, 1, 1, 1, 1, 1, 1, 0,
				0, 1, 1, 1, 1, 1, 1, 1, 0,
				1, 1, 1, 1, 1, 1, 1, 1, 1,
				1, 1, 1, 1, 1, 1, 1, 1, 1,
				1, 1, 1, 1, 1, 1, 1, 1, 1,
				0, 1, 1, 1, 1, 1, 1, 1, 0,
				0, 1, 1, 1, 1, 1, 1, 1, 0,
				0, 0, 0, 1, 1, 1, 0, 0, 0,	*/

				9, 9, 0,
				0, 0, 0, 0, 1, 0, 0, 0, 0,
				0, 0, 1, 1, 1, 1, 1, 0, 0,
				0, 1, 1, 1, 1, 1, 1, 1, 0,
				0, 1, 1, 1, 1, 1, 1, 1, 0,
				1, 1, 1, 1, 1, 1, 1, 1, 1,
				0, 1, 1, 1, 1, 1, 1, 1, 0,
				0, 1, 1, 1, 1, 1, 1, 1, 0,
				0, 0, 1, 1, 1, 1, 1, 0, 0,
				0, 0, 0, 0, 1, 0, 0, 0, 0,

			/*	7, 7, 0,
				0, 0, 1, 1, 1, 0, 0,
				0, 1, 1, 1, 1, 1, 0,
				1, 1, 1, 1, 1, 1, 1,
				1, 1, 1, 1, 1, 1, 1,
				1, 1, 1, 1, 1, 1, 1,
				0, 1, 1, 1, 1, 1, 0,
				0, 0, 1, 1, 1, 0, 0,	*/

				7, 7, 0,
				0, 0, 0, 1, 0, 0, 0,
				0, 1, 1, 1, 1, 1, 0,
				0, 1, 1, 1, 1, 1, 0,
				1, 1, 1, 1, 1, 1, 1,
				0, 1, 1, 1, 1, 1, 0,
				0, 1, 1, 1, 1, 1, 0,
				0, 0, 0, 1, 0, 0, 0,

				5, 5, 0,
				0, 1, 1, 1, 0,
				1, 1, 1, 1, 1,
				1, 1, 1, 1, 1,
				1, 1, 1, 1, 1,
				0, 1, 1, 1, 0,

				5, 5, 0,
				0, 0, 1, 0, 0,
				0, 1, 1, 1, 0,
				1, 1, 1, 1, 1,
				0, 1, 1, 1, 0,
				0, 0, 1, 0, 0,

				3, 3, 0,
				1, 1, 1,
				1, 1, 1,
				1, 1, 1,

				0, 0, 0 };

	IMG Glow = Image;
	Glow.Data = (PIX_BGRA*) calloc (Image.Size, sizeof (PIX_BGRA));

	for (int Pass = 1; Pass >= 0; Pass--)
	{
	    int ListLoc = 0;
	    for (int Col = 14; Col > 7; Col--)
	    {
		int ColSlot = Col+(Pass*3);
		if (ColSlot > 14) { ColSlot = 0; }
		char *List = &GlowList [ListLoc];
		int W = *List++;
		int H = *List++;
		int DITHER = *List++;
		ListLoc += 3 + (W * H);
		for (int Y = 1; Y < (Image.SizeY - 1); Y++)
		{
			for (int X = 1; X < (Image.SizeX - 1); X++)
			{
				if (COMPCOL (Image.Data [XY(X, Y)], Palette.Data [4+Pass]))
				{
					for (int XP = 0; XP < W; XP++)
					{
						for (int YP = 0; YP < H; YP++)
						{
							if (List [XP + (YP*W)] != 0)
							{
								if (DITHER == 0)
								{
									int CC =	Glow.Data [XY(X+(XP-(W/2)), Y+(YP-(H/2)))].Red +\
											Glow.Data [XY(X+(XP-(W/2)), Y+(YP-(H/2)))].Green +\
											Glow.Data [XY(X+(XP-(W/2)), Y+(YP-(H/2)))].Blue;
									int PC =	Palette.Data [ColSlot].Red +\
											Palette.Data [ColSlot].Green +\
											Palette.Data [ColSlot].Blue;
									if (CC < PC)
									{
										Glow.Data [XY(X+(XP-(W/2)), Y+(YP-(H/2)))] = Palette.Data [ColSlot];
									}
								}
								else
								{
									int XA = 0;
									XA = (Y+(YP-(H/2))) & 1;
									int CC =	Glow.Data [XY(((X&-2)+XA)+(XP-(W/2)), Y+(YP-(H/2)))].Red +\
											Glow.Data [XY(((X&-2)+XA)+(XP-(W/2)), Y+(YP-(H/2)))].Green +\
											Glow.Data [XY(((X&-2)+XA)+(XP-(W/2)), Y+(YP-(H/2)))].Blue;
									int PC =	Palette.Data [ColSlot].Red +\
											Palette.Data [ColSlot].Green +\
											Palette.Data [ColSlot].Blue;
									if (CC < PC)
									{
										Glow.Data [XY(((X&-2)+XA)+(XP-(W/2)), Y+(YP-(H/2)))] = Palette.Data [ColSlot];
									}
								}
							}
						}
					}
				}
			}
		}
	    }
	}
	for (int Loc = 0; Loc < Image.Size; Loc++)
	{
		if (NEGACOL (Image.Data [Loc], Palette.Data [0]))
		{
			Glow.Data [Loc] = Image.Data [Loc];
		}
	}
	free (Image.Data);
	Image = Glow;
}

// -----------------------------------------------------------------------------
// Patching an image to the right of another image
// -----------------------------------------------------------------------------

void PatchImage (IMG Palette, IMG &Image, IMG Add)

{
	int Start = Image.SizeY;
	TruncateImage (&Image, 0, 0, Image.SizeX, Image.SizeY+Add.SizeY, Palette.Data [0]);
	for (int Y = Start, Loc = 0; Y < Image.SizeY; Y++)
	{
		for (int X = 0; X < Image.SizeX; X++)
		{
			Image.Data [XY (X, Y)] = Add.Data [Loc++];
		}
	}
}

// -----------------------------------------------------------------------------
// Entry point
// -----------------------------------------------------------------------------

int main (int ArgNumber, char **ArgList, char **EnvList)

{
	IMG Palette, Head, Text, Fade, Both;
	int Return = 0;

	Return |= ImageLoad (&Palette, (char*) PalFile);
	Return |= ImageLoad (&Head, (char*) HeadFile);
	Return |= ImageLoad (&Text, (char*) TextFile);
	if (Return != 0)
	{
		printf ("Could not load one of the files:\n\n"
			"    \"%s\", \"%s\", \"%s\"\n\n"
			"Please make sure they all exist...\n\n", PalFile, HeadFile, TextFile);
		free (Palette.Data); Palette.Data = NULL;
		free (Head.Data); Head.Data = NULL;
		free (Text.Data); Text.Data = NULL;
		fflush (stdin); getchar ( ); return (0x00);
	}
	FlipImage (&Head);
	FlipImage (&Text);

	// --- Palette ---

	int Pos = 0;
	PIX_BGRA BACKDROP = Palette.Data [0];
	for (int Loc = 0; Loc < Palette.Size; Loc++)
	{
		if (	BACKDROP.Red   == Palette.Data [Loc].Red   &&
			BACKDROP.Green == Palette.Data [Loc].Green &&
			BACKDROP.Blue  == Palette.Data [Loc].Blue  )
		{
			continue;
		}
		int Col;
		for (Col = 0; Col < Pos; Col++)
		{
			if (	Palette.Data [Col].Red   == Palette.Data [Loc].Red   &&
				Palette.Data [Col].Green == Palette.Data [Loc].Green &&
				Palette.Data [Col].Blue  == Palette.Data [Loc].Blue  )
			{
				break;
			}
		}
		if (Col >= Pos)
		{
			Palette.Data [Pos++] = Palette.Data [Loc];
		}
	}
	Palette.Size = Pos;
	Palette.SizeX = Pos;
	Palette.SizeY = 1;

	// --- Making a fusion of both ---

	Both = Head;
	Both.Data = (PIX_BGRA*) calloc (Both.Size, sizeof (PIX_BGRA));
	for (int Loc = 0; Loc < Both.Size; Loc++)
	{
		Both.Data [Loc] = Head.Data [Loc];
		if (COMPCOL (Head.Data [Loc], Palette.Data [5]))
		{
			Both.Data [Loc] = Palette.Data [4];
		}
	}
	for (int Loc = 0; Loc < Both.Size; Loc++)
	{
		if (NEGACOL (Text.Data [Loc], Palette.Data [0]))
		{
			Both.Data [Loc] = Text.Data [Loc];
		}
	}
	Fade = Both;
	Fade.Data = (PIX_BGRA*) calloc (Fade.Size, sizeof (PIX_BGRA));
	for (int Loc = 0; Loc < Fade.Size; Loc++)
	{
		Fade.Data [Loc] = Head.Data [Loc];
	}
	for (int Loc = 0; Loc < Fade.Size; Loc++)
	{
		if (NEGACOL (Text.Data [Loc], Palette.Data [0]))
		{
			Fade.Data [Loc] = Text.Data [Loc];
		}
	}

	// --- Putting fade in ---

	for (int Loc = 0; Loc < Head.Size; Loc++)
	{
		if (COMPCOL (Head.Data [Loc], Palette.Data [5]))
		{
			Head.Data [Loc] = Palette.Data [4];
		}
	}

	AddPale (Palette, Head);
	AddGlow (Palette, Head);

	AddPale (Palette, Text);
	AddGlow (Palette, Text);

	AddPale (Palette, Fade);
	AddGlow (Palette, Fade);

	AddPale (Palette, Both);
	AddGlow (Palette, Both);

	for (int Loc = 0; Loc < Fade.Size; Loc++)
	{
		if (COMPCOL (Fade.Data [Loc], Palette.Data [5]))
		{
			Fade.Data [Loc] = Palette.Data [7];
		}
	}

	PatchImage (Palette, Both, Fade);
	PatchImage (Palette, Both, Text);
	FlipImage (&Both);
	SaveBMP (&Both, "Logo.bmp", 24);


	// --- Finish ---

	free (Palette.Data); Palette.Data = NULL;
	free (Head.Data); Head.Data = NULL;
	free (Both.Data); Both.Data = NULL;
	free (Fade.Data); Fade.Data = NULL;
	free (Text.Data); Text.Data = NULL;

	printf ("Finished...\n");
	fflush (stdin); getchar ( ); return (0x00);
}

// =============================================================================
